﻿uses System.Text;

// операции:
type
   Op = (Add, Sub, Mul, Divs);

const
   OpChars: array[Op] of char = ('+', '-', '*', '/');
   Target = 24.0;
   Epsilon = 1e-6;

function Calculate(a, b: real; op: Op): real;
begin
   case op of
      Add: Result := a + b;
      Sub: Result := a - b;
      Mul: Result := a * b;
      Divs: 
         if Abs(b) > Epsilon then 
            Result := a / b
         // очень большое число при делении на 0:
         else 
            Result := 1e30; 
   end;
end;


function Solve24(nums: array of integer): List<string>;
  // генерируем все перестановки чисел
  var permutations := new List<array of integer>;
      perm := nums.Clone() as array of integer;
   
   // рекурсивная генерация перестановок
   procedure GeneratePermutations(k: integer);
   begin
      if k = 1 then
         permutations.Add(perm.Clone() as array of integer)
      else
      begin
         GeneratePermutations(k - 1);
         for var i := 0 to k - 2 do
         begin
            if k mod 2 = 0 then
               Swap(perm[i], perm[k - 1])
            else
               Swap(perm[0], perm[k - 1]);
            GeneratePermutations(k - 1);
         end;
      end;
   end;

begin
   Result := new List<string>;
   var n := nums.Length;
   GeneratePermutations(n);
   
   // для каждой перестановки чисел и 
   // каждой комбинации операций:
   for var permIdx := 0 to permutations.Count - 1 do
   begin
      var numsPerm := permutations[permIdx];
      
      // 5 возможных структур скобок для 4 чисел:
      // 1) ((a op b) op c) op d
      // 2) (a op (b op c)) op d
      // 3) a op ((b op c) op d)
      // 4) a op (b op (c op d))
      // 5) (a op b) op (c op d)
      
      // перебираем все комбинации операций (4^3 = 64 комбинаций):
      for var op1 := Op.Add to Op.Divs do
         for var op2 := Op.Add to Op.Divs do
            for var op3 := Op.Add to Op.Divs do
            begin
               var a := real(numsPerm[0]);
               var b := real(numsPerm[1]);
               var c := real(numsPerm[2]);
               var d := real(numsPerm[3]);
               
               // 1) ((a op1 b) op2 c) op3 d
               try
                  var r1 := Calculate(a, b, op1);
                  var r2 := Calculate(r1, c, op2);
                  var r3 := Calculate(r2, d, op3);
                  if Abs(r3 - Target) < Epsilon then
                     Result.Add($'(({a} {OpChars[op1]} {b}) {OpChars[op2]} {c}) {OpChars[op3]} {d} = 24');
               except
               end;
               
               // 2) (a op1 (b op2 c)) op3 d
               try
                  var r1 := Calculate(b, c, op2);
                  var r2 := Calculate(a, r1, op1);
                  var r3 := Calculate(r2, d, op3);
                  if Abs(r3 - Target) < Epsilon then
                     Result.Add($'({a} {OpChars[op1]} ({b} {OpChars[op2]} {c})) {OpChars[op3]} {d} = 24');
               except
               end;
               
               // 3) a op1 ((b op2 c) op3 d)
               try
                  var r1 := Calculate(b, c, op2);
                  var r2 := Calculate(r1, d, op3);
                  var r3 := Calculate(a, r2, op1);
                  if Abs(r3 - Target) < Epsilon then
                     Result.Add($'{a} {OpChars[op1]} (({b} {OpChars[op2]} {c}) {OpChars[op3]} {d}) = 24');
               except
               end;
               
               // 4) a op1 (b op2 (c op3 d))
               try
                  var r1 := Calculate(c, d, op3);
                  var r2 := Calculate(b, r1, op2);
                  var r3 := Calculate(a, r2, op1);
                  if Abs(r3 - Target) < Epsilon then
                     Result.Add($'{a} {OpChars[op1]} ({b} {OpChars[op2]} ({c} {OpChars[op3]} {d})) = 24');
               except
               end;
               
               // 5) (a op1 b) op2 (c op3 d)
               try
                  var r1 := Calculate(a, b, op1);
                  var r2 := Calculate(c, d, op3);
                  var r3 := Calculate(r1, r2, op2);
                  if Abs(r3 - Target) < Epsilon then
                     Result.Add($'({a} {OpChars[op1]} {b}) {OpChars[op2]} ({c} {OpChars[op3]} {d}) = 24');
               except
               end;
            end;
   end;
end;


// ГЕНЕРИРУЕМ ЗАДАЧИ
procedure Generate;
begin
   Writeln(' Введите 4 числа от 1 до 10 (через пробел):');
   while True do
   begin
      var nums := ReadString().ToWords().Select(x -> x.ToInteger()).ToArray(); 
      
      if nums.Length <> 4 then
      begin
         Writeln(' Нужно ввести ровно 4 числа!');
         Exit;
      end;
      
      if nums.Any(x -> (x < 1) or (x > 10)) then
      begin
         Writeln('Числа должны быть от 1 до 10!');
         Exit;
      end;
      
      Writeln;
      Writeln('Ищем решения для чисел: ', nums[0], ', ', nums[1], ', ', nums[2], ', ', nums[3]);
      Writeln('==========================================');
      
      var solutions := Solve24(nums);
      
      if solutions.Count = 0 then
         Writeln('Решений не найдено!')
      else
      begin
         // убираем дубликаты:
         var uniqueSolutions := solutions.Distinct().ToList();
         
         Writeln('Найдено решений: ', uniqueSolutions.Count);
         Writeln;
         
         for var i := 0 to uniqueSolutions.Count - 1 do
            Writeln(uniqueSolutions[i]);
      end;
      Writeln;
   end;
end;


begin
   WriteLn(' Игра 24');
   WriteLn;     
   Generate;
end.